<?php
/**
 * Mollie Payment Gateway
 */

return [
    "default" => function(&$request){
        if(!$this->session->has("logged"))
            $this->header->redirect(site_url("dashboard/auth"));

        $plugin = $this->system->getPlugin($request["name"], "directory");

        if(!$plugin)
            $this->pluginError(__("plugin_generic_unabletoprocess"));

        $pluginData = json_decode($plugin["data"], true);

        $getItem = $this->system->getOrder(logged_id, "uid");

        if(!$getItem)
            $this->pluginError(__("plugin_generic_unabletoprocess"));

        $item = json_decode($getItem["data"], true);

        try {
            $mollie = new \Mollie\Api\MollieApiClient();
			$mollie->setApiKey($pluginData["apikey"]);

            $paymentId = uniqid(time());

            if($item["type"] < 2):
                $payment = $mollie->payments->create([
                    "amount" => [
                        "currency" => $pluginData["currency_conversion"] == "true" ? "USD" : $item["data"]["base_currency"],
                        "value" => number_format(($pluginData["currency_conversion"] == "true" ? $item["data"]["converted_price"] : $item["data"]["original_price"]), 2, '.', '')
                    ],
                    "description" => $item["data"]["package"]["name"],
                    "redirectUrl" => site_url("plugin?name={$request["name"]}&hash={$item["data"]["user"]["hash"]}&action=success", true),
                    "webhookUrl"  => site_url("plugin?name={$request["name"]}&hash={$item["data"]["user"]["hash"]}&action=webhook&json=true", true),
                    "metadata" => [
                        "order_id" => $paymentId
                    ]
                ]);
            else:
                $payment = $mollie->payments->create([
                    "amount" => [
                        "currency" => $pluginData["currency_conversion"] == "true" ? "USD" : $item["data"]["base_currency"],
                        "value" => number_format(($pluginData["currency_conversion"] == "true" ? $item["data"]["converted_price"] : $item["data"]["original_price"]), 2, '.', '')
                    ],
                    "description" => __("widget_payment_creditslabel"),
                    "redirectUrl" => site_url("plugin?name={$request["name"]}&hash={$item["data"]["user"]["hash"]}&action=success", true),
                    "webhookUrl"  => site_url("plugin?name={$request["name"]}&hash={$item["data"]["user"]["hash"]}&action=webhook&json=true", true),
                    "metadata" => [
                        "order_id" => $paymentId
                    ]
                ]);
            endif;

            $this->header->redirect($payment->getCheckoutUrl());
        } catch (Exception $e) {
            $this->pluginError(___(__("plugin_generic_wentwrongerr"), [$e->getMessage()]));
        }
    },
    "success" => function(&$request){
        if(!$this->session->has("logged"))
            $this->header->redirect(site_url("dashboard/auth"));

        $vars = [
            "title" => __("title_payment_success"),
            "page" => "misc/payment",
            "data" => [
            	"message" => __("and_dash_pg_pay_line45")
            ]
        ];

        $this->smarty->assign($vars);
        $this->smarty->display(template . "/header.tpl");
        $this->smarty->display(__DIR__ . "/views/success.tpl");
        $this->smarty->display(template . "/footer.tpl");
    },
    "webhook" => function(&$request){
        if(!isset($request["id"], $request["hash"], $request["json"]))
            response(500);
        
        $plugin = $this->system->getPlugin($request["name"], "directory");

        if(!$plugin)
            response(500);

        $pluginData = json_decode($plugin["data"], true);

        $mollie = new \Mollie\Api\MollieApiClient();
        $mollie->setApiKey($pluginData["apikey"]);

        try {
            $payment = $mollie->payments->get($request["id"]);
        } catch (Exception $e) {
            response(500);
        }

        $getItem = $this->system->getOrder($request["hash"], "hash");

        if(!$getItem)
            response(404);

        $item = json_decode($getItem["data"], true);
        $user = $this->system->getUser($item["data"]["user"]["id"]);

        if(!$user)
            response(500);

        $txn = $request["id"];

        if($payment->isPaid() && !$payment->hasRefunds() && !$payment->hasChargebacks()):
            $this->system->delete($getItem["uid"], false, "orders");
            
            if($item["type"] < 2):
                if($this->system->checkSubscription($user["id"]) > 0):
                    $subscription = $this->system->getSubscription(false, $user["id"]);
                    
                    if($subscription && isset($subscription["sid"])):
                        $currentExpiry = strtotime($subscription["sub_date"]);
                        $now = time();
                    
                        $startFrom = ($currentExpiry > $now) ? $currentExpiry : $now;
                    
                        $newExpiry = date("Y-m-d H:i:s", strtotime("+{$item["data"]["duration"]} months", $startFrom));
                    
                        $transaction = $this->system->create("transactions", [
                            "uid" => $user["id"],
                            "pid" => $item["data"]["package"]["id"],
                            "type" => 1,
                            "price" => $item["data"]["original_price"],
                            "currency" => system_currency,
                            "duration" => $item["data"]["duration"],
                            "provider" => "mollie",
                            "txn" => $txn
                        ]);
                    
                        $filtered = [
                            "pid" => $item["data"]["package"]["id"],
                            "tid" => $transaction,
                            "date" => $newExpiry
                        ];
                    
                        $this->system->update($subscription["sid"], $user["id"], "subscriptions", $filtered);
                    else:
                        $newExpiry = date("Y-m-d H:i:s", strtotime("+{$item["data"]["duration"]} months"));
                    
                        $transaction = $this->system->create("transactions", [
                            "uid" => $user["id"],
                            "pid" => $item["data"]["package"]["id"],
                            "type" => 1,
                            "price" => $item["data"]["original_price"],
                            "currency" => system_currency,
                            "duration" => $item["data"]["duration"],
                            "provider" => "mollie",
                            "txn" => $txn
                        ]);
                    
                        $filtered = [
                            "uid" => $user["id"],
                            "pid" => $item["data"]["package"]["id"],
                            "tid" => $transaction,
                            "date" => $newExpiry
                        ];
                    
                        $this->system->create("subscriptions", $filtered);
                    endif;             
                else:
                    $newExpiry = date("Y-m-d H:i:s", strtotime("+{$item["data"]["duration"]} months"));
                
                    $transaction = $this->system->create("transactions", [
                        "uid" => $user["id"],
                        "pid" => $item["data"]["package"]["id"],
                        "type" => 1,
                        "price" => $item["data"]["original_price"],
                        "currency" => system_currency,
                        "duration" => $item["data"]["duration"],
                        "provider" => "mollie",
                        "txn" => $txn
                    ]);
                
                    $filtered = [
                        "uid" => $user["id"],
                        "pid" => $item["data"]["package"]["id"],
                        "tid" => $transaction,
                        "date" => $newExpiry
                    ];
                
                    $this->system->create("subscriptions", $filtered);
                endif; 

                $this->mail->send([
                    "title" => system_site_name,
                    "data" => [
                        "subject" => mail_title(__("response_package_purchasedtitle")),
                        "package" => $item["data"]["package"],
                        "subscription" => $this->system->getSubscription(false, $user["id"])
                    ]
                ], $user["email"], "_mail/subscribe.tpl", $this->smarty);

                if(!empty(system_mailing_address) && in_array("admin_package_buy", explode(",", system_mailing_triggers))):
                    $packageWorth = "{$item["data"]["package"]["price"]} " . system_currency;

                    $mailingContent = <<<HTML
                    <p>Hi there!</p>
                    <p>This is to inform you that <strong>{$user["email"]}</strong> has bought <strong>{$item["data"]["package"]["name"]}</strong> package worth <strong>{$packageWorth}</strong> via <strong>Mollie</strong>.</p> 
                    HTML;

                    $this->mail->send([
                        "title" => system_site_name,
                        "data" => [
                            "subject" => mail_title("Admin Alert Message from " . system_site_name . "!"),
                            "content" => $mailingContent
                        ]
                    ], system_mailing_address, "_mail/default.tpl", $this->smarty);
                endif;
            else:
                $transaction = $this->system->create("transactions", [
                    "uid" => $user["id"],
                    "pid" => 0,
                    "type" => 2,
                    "price" => $item["data"]["credits"],
                    "currency" => system_currency,
                    "duration" => 0,
                    "provider" => "mollie",
                    "txn" => $txn
                ]);

                $this->system->credits($user["id"], "increase", $item["data"]["credits"]);

                $this->mail->send([
                    "title" => system_site_name,
                    "data" => [
                        "subject" => mail_title(__("payment_webhook_paypalcreditsadded")),
                        "credits" => $item["data"]["credits"]
                    ]
                ], $user["email"], "_mail/credits.tpl", $this->smarty);

                if(!empty(system_mailing_address) && in_array("admin_credits_buy", explode(",", system_mailing_triggers))):
                    $mailingContent = <<<HTML
                    <p>Hi there!</p>
                    <p>This is to inform you that <strong>{$user["email"]}</strong> has bought <strong>{$item["data"]["credits"]}</strong> credits via <strong>Mollie</strong>.</p> 
                    HTML;

                    $this->mail->send([
                        "title" => system_site_name,
                        "data" => [
                            "subject" => mail_title("Admin Alert Message from " . system_site_name . "!"),
                            "content" => $mailingContent
                        ]
                    ], system_mailing_address, "_mail/default.tpl", $this->smarty);
                endif;
            endif;

            $this->cache->container("system.transactions");
            $this->cache->clear();
        else:
            $this->mail->send([
                "title" => system_site_name,
                "data" => [
                    "subject" => mail_title(__("payment_transact_failed")),
                    "order" => $txn ?: __("payment_webhook_unknowntn")
                ]
            ], $user["email"], "_mail/failed.tpl", $this->smarty);
        endif;

        response(200);
    }
];