<?php

class Device_Model extends MVC_Model
{
    public function checkUserId($id)
    {
        $this->db->query("SELECT id FROM users WHERE id = ?", [
            $id
        ]);

        return $this->db->num_rows();
    }

    public function checkUserEmail($email)
    {
        $this->db->query("SELECT id FROM users WHERE email = ?", [
            $email
        ]);

        return $this->db->num_rows();
    }

	public function checkDevice($did)
    {
        $this->db->query("SELECT id FROM devices WHERE did = ?", [
            $did
        ]);
        
        return $this->db->num_rows();
    }

    public function checkSuspension($uid)
    {
        $this->db->query("SELECT id FROM users WHERE id = ? AND suspended > 0", [
            $uid
        ]);

        return $this->db->num_rows();
    }

    public function checkReceived($rid, $uid, $did)
    {
        $this->db->query("SELECT id FROM received WHERE rid = ? AND uid = ? AND did = ?", [
            $rid,
            $uid,
            $did
        ]);

        return $this->db->num_rows();
    }

    public function getDevice($did)
    {
        return $this->db->query_one("SELECT id, uid, did, name, version, manufacturer, random_send, random_min, random_max, packages, receive_sms, global_device, global_priority, global_slots, country, rate, create_date FROM devices WHERE did = ?", [
            $did
        ]);
    }

    public function getUssd($id)
    {
        return $this->db->query_one("SELECT id, uid, did, code, sim, status, create_date FROM ussd WHERE id = ?", [
            $id
        ]);
    }

    public function getPendingMessages($did, $diff)
    {
        $query = <<<SQL
SELECT s.id AS id, s.uid AS uid, IF(c.id, c.id, 0) AS cid, s.sim AS sim, s.phone AS recipient, s.message AS message, s.priority AS priority
FROM sent s
LEFT JOIN campaigns c ON s.cid = c.id
WHERE s.did = ? AND s.status < 2
LIMIT {$diff}
SQL;

        $this->db->query($query, [
            $did
        ]);

        if ($this->db->num_rows() > 0):
            while ($row = $this->db->next())
                $rows[] = $row;

            return $rows;
        else:
            return [];
        endif;
    }

    public function getPendingUssd($did)
    {
        $query = <<<SQL
SELECT id, uid, sim, code
FROM ussd
WHERE did = ? AND status < 2
SQL;

        $this->db->query($query, [
            $did
        ]);

        if ($this->db->num_rows() > 0):
            while ($row = $this->db->next())
                $rows[] = $row;

            return $rows;
        else:
            return [];
        endif;
    }

    public function getWebhooks($uid, $event)
    {
        $query = <<<SQL
SELECT id, secret, url, events
FROM webhooks
WHERE uid = ? AND FIND_IN_SET(?, events)
SQL;

        $this->db->query($query, [
            $uid,
            $event
        ]);

        if ($this->db->num_rows() > 0):
            while ($row = $this->db->next())
                $rows[] = $row;

            return $rows;
        else:
            return [];
        endif;
    }

    public function getActions($uid, $type)
    {
        $query = <<<SQL
SELECT a.id, a.type, a.source, a.`event`, a.priority, a.`match`, a.sim, a.ai_key, k.id AS ai_key_id, k.prompt AS ai_prompt, k.provider AS `provider`, k.post_prompt AS ai_post_prompt, k.model AS ai_model, k.history AS ai_history, k.max_tokens AS ai_max_tokens, k.vision AS ai_vision, k.transcription AS ai_transcription, k.apikey AS ai_apikey, a.ai_plugins, a.device, a.keywords, a.link, a.message
FROM actions a
LEFT JOIN ai_keys k ON a.ai_key = k.id
WHERE a.uid = ? AND a.type = ? AND a.source < 2
SQL;

        $this->db->query($query, [
            $uid,
            $type
        ]);

        if ($this->db->num_rows() > 0):
            while ($row = $this->db->next())
                $rows[] = $row;

            return $rows;
        else:
            return [];
        endif;
    }
}